#include "stdafx.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <afxtempl.h>

#include "mpegsound.h"

DWORD threadID;
HANDLE threadHandle;

CM1Dlg * md;

extern MyDsound * mds;
extern HICON icoPlay;
extern HICON icoPlayOn;
extern BOOL usePlayList;
extern BOOL useVolumeBars;
extern BOOL useSurroundSound;
extern BOOL odViewable;
extern BOOL pdViewable;
extern BOOL stereo;
extern COptionsDlg * od;
extern CPlaylistDlg * pd;
extern CFont myFont;
extern long hertz;

//vars for timer
long counter = 0;
char curtime[10];

void CALLBACK EXPORT TimerProc(
   HWND hWnd,      //handle of CWnd that called SetTimer
   UINT nMsg,      //WM_TIMER
   UINT nIDEvent,   //timer identification
   DWORD dwTime   //system time
)
{
	long lvol=0;
	long rvol=0; 
	long curpoint;
	short temp;
	DWORD tempP;
	DWORD tempW;
	short * cutoff;
	short * buf;
	char bufferThingy[30];
	
	counter++;

	if((mds)&&(mds->playing==true)&&(useVolumeBars==true)&&(!(counter%20)))//hopefully a short circuiting compiler...
	{
		mds->lpDSBStreamBuffer->GetCurrentPosition(&tempP,&tempW);

		buf = mds->myBuffer + tempP-2205;
		if(buf<mds->myBuffer) buf = mds->myBuffer;
		cutoff = mds->myBuffer + mds->bufferSize;

		lvol=0;
		rvol=0;
		for(int l=0; l <4410; l++)
		{
			lvol = (temp=abs(buf[0])) > lvol ? temp : lvol;
			rvol = (temp=abs(buf[1])) > rvol ? temp : rvol;
			buf+=4;
			if(buf>=cutoff) buf = mds->myBuffer;
		}

		lvol = 100*lvol/32768;
		rvol = 100*rvol/32768;
/*		for(int l=0; l <4410; l++)
		{
			lvol += abs(buf[0]);
			rvol += abs(buf[1]);
			buf+=4;//*(4410/200);
			if(buf>=cutoff) buf = mds->myBuffer;
		}

//		lvol = lvol/10;
		lvol = lvol/4/32768;
//		rvol = rvol/4410;
		rvol = rvol/4/32768;*/
	
		md->m_lVolume.SetPos(lvol);
		md->m_rVolume.SetPos(rvol);
	}

	if((mds)&&(mds->playing==true)&&(useVolumeBars==true)&&(!(counter%5)))//hopefully a short circuiting compiler...
	{
		md->m_lVolume.OffsetPos(-4);
		md->m_rVolume.OffsetPos(-4);
	}
	
	if((mds)&&(mds->playing==true)&&(!(counter%100)))
	{
		mds->lpDSBStreamBuffer->GetCurrentPosition(&tempP,&tempW);
		curpoint = (tempP + mds->playWrap * mds->bufferSize)/(4*hertz);
		curpoint /=60;
		_itoa(curpoint,bufferThingy,10);
		if(bufferThingy[1] == NULL)
		{
			bufferThingy[1] = bufferThingy[0];
			bufferThingy[0] = '0';
			bufferThingy[2] = ':';
			bufferThingy[3] = NULL;
		}
		curpoint = (tempP + mds->playWrap * mds->bufferSize)/(4*hertz);
		curpoint %=60;
		_itoa(curpoint,bufferThingy+3,10);
		if(bufferThingy[4] == NULL)
		{
			bufferThingy[4] = bufferThingy[3];
			bufferThingy[3] = '0';
			bufferThingy[5] = NULL;
		}
		md->m_playPoint.SetWindowText(bufferThingy);
		strcpy(curtime,bufferThingy);
	}

	//make the pause button flash
	if((mds!=NULL)&&(mds->paused==true))
	{
		if(!(counter%80))
		{
			md->m_playPoint.SetWindowText(curtime);
			md->m_play.SetIcon(icoPlayOn);
		}
		if(!((counter+40)%80))
		{
			md->m_playPoint.SetWindowText("--:--");
			md->m_play.SetIcon(icoPlay);
		}
	}
}

static char *Sounderrors[SOUND_ERROR_UNKNOWN]=
{ "Failed to open sound device.",
  "Sound device is busy.",
  "Buffersize of sound device is wrong.",
  "Sound device control error.",

  "Failed to open file for reading.",
  "Failed to read file.",

  "Not enough Memory.",
  "Unexpected EOF.",
  "Bad sound file format.",

  "Cannot make thread.",

  "Unknown error.",
};

static int verbose=0;
static const char *package="PACKAGE";//PACKAGE;
static const char *version="VERSION";//VERSION;
static char *devicename=NULL;
static char *progname;
static bool forcetomonoflag=false;
bool stop = false;

int playlistsong=0;

inline void error(int n)
{
  fprintf(stderr,"%s: %s\n",progname,Sounderrors[n-1]);
  return;
}

void go(char * filename)
{
	Fileplayer *player;
	char tempfile[255];

	strcpy(tempfile,filename);
	tempfile[strlen(tempfile)-4] = NULL;
	md->m_songName.SetWindowText(strrchr(tempfile,'\\')+1); 

	md->timerID = md->SetTimer(1,10,TimerProc);

    player=new Mpegfileplayer;
    player->openfile(filename,devicename);
	player->playing(0);

	while((mds->playing)&&(!mds->paused)&&(mds->ValidBufferLeft()>4000)&&(!mds->exit))
	{
		if(stop)
		{
			md->KillTimer(md->timerID);
			mds->Die();
			delete player;
			md->m_play.SetWindowText(">");
			md->m_play.SetIcon(icoPlay);
			delete mds;
			mds = NULL;
			return;
		}
//		mds->progress->SetPos(mds->PercentValidBufferLeft());
		Sleep(10);
	}
	md->KillTimer(md->timerID);
	mds->Die();
	delete mds;
	mds = NULL;
	delete player;
	stop = false;
}


void play(CM1Dlg *d)
{
	char * filename;

	filename = d->mp3Name;
	md = d;

	if(verbose)
    fprintf(stderr,"%s: \n",filename);
	if(strstr(filename,".mp") || strstr(filename,".MP") || strstr(filename,".Mp") || strstr(filename,".mP"))
	{
		usePlayList = false;
		go(filename);
	}
	else if(strstr(filename,".m3u") || strstr(filename,".M3U") || strstr(filename,".m3U") || strstr(filename,".M3u"))
	{
		CStdioFile * m3ulist;
		char * path;
		CArray <CString*,CString*> pArray;
		filename = new char[255];
		LPTSTR p;
		
		strcpy(filename,d->mp3Name);
		
		m3ulist = new CStdioFile(filename,CFile::modeRead | CFile::typeText);
		while(m3ulist->ReadString(filename,500)) //read until no more files
		{
			pArray.Add(new CString(filename));
		}
		delete m3ulist;

		usePlayList = true;
		while(pArray.GetUpperBound() >= playlistsong) //read until no more files
		{
			strcpy(filename,p = ((CString*)pArray[playlistsong])->GetBuffer(0));
			playlistsong++;
			if(filename[strlen(filename)-1]==0x0a) filename[strlen(filename)-1] = 0;
			if(strstr(filename,".mp") || strstr(filename,".MP") || strstr(filename,".Mp") || strstr(filename,".mP"))
			{
				go(filename);
			}
		}
	}
	else
	{
		return;
	}
	
}
	
