/* MPEG/WAVE Sound library

   (C) 1997 by Jung woo-jae */

// Bitwindow.cc

// It's for MPEG layer 3

#include "stdafx.h"
#include "mpegsound.h"

#ifndef WORDS_BIGENDIAN
#define _KEY 0
#else
#define _KEY 3
#endif

int Mpegbitwindow::getbits(int bits)
{
	//bitindex seems to be the total bits into the file... so i guess this gets the next
	//couple bits from bitindex

  unsigned short temp;
  int bi;

	union
  {
    char store[4];
    int current;
  }u;


  u.current=0;
  bi=(bitindex&7); //get the nuber of bits more than last byte boundary
  u.store[_KEY]=buffer[(bitindex>>3)&(WINDOWSIZE-1)]<<bi; // find the proper position in the bit buffer for
														  // this particular bitindex and put it in the
														// store[0] position shifted by number of extra bits.
														// I assume this is so the bits can be pushed on from
														//the left side later.
  bi=8-bi; // find number of availible bits in this byte
  bitindex+=bi;//point bit index to next byte boundary

  while(bits)
  {
    if(!bi)  //if no extra bits
    {
      u.store[_KEY]=buffer[(bitindex>>3)&(WINDOWSIZE-1)];
      bitindex+=8;
      bi=8;  //set the next number of bits to read to 8
    }

    if(bits>=bi)
    {
      u.current<<=bi;
      bits-=bi;
      bi=0;
    }
    else
    {
      u.current<<=bits;
      bi-=bits;
      bits=0;
    }
  }
  bitindex-=bi;
	
  bitbucket = buffer[(bitindex>>3)&(WINDOWSIZE-1)];
  bitbucket <<= (bitindex & 0x7);

  return (u.current>>8);
}
