/* MPEG/WAVE Sound library

   (C) 1997 by Jung woo-jae */

// Fileplayer.cc
// It's an example for how to use MPEG/WAVE Sound library

#include "stdafx.h"
#include <fcntl.h>
#include "mpegsound.h"
#include "M1.h"
#include "M1Dlg.h"

extern CM1Dlg * d;

extern BOOL stereo;
extern long hertz;
extern long bitrate;


static char *defaultdevice="/dev/dsp";

// Wave file player
bool Wavefileplayer::openfile(char *filename,char *device)
{
// Player
  if(device==NULL)device=defaultdevice;

  if(device[0]=='/')player=new Rawplayer;
  else 
  {
    if(device[0]=='-')device=NULL;
    player=new Rawtofile;
  }

  if(player==NULL)
    return error(SOUND_ERROR_MEMORYNOTENOUGH);
  if(!player->initialize(device))return error(player->geterrorcode());

// Loader
  if(filename)
  {
    if((filehandle=open(filename,O_RDONLY|O_BINARY,0))==-1)
      return error(SOUND_ERROR_FILEOPENFAIL);
  }
  else filehandle=0;

  if((loader=new Soundinputstreamfromfile(filehandle))==NULL)
    return error(SOUND_ERROR_MEMORYNOTENOUGH);

// Server
  if((server=new Wavetoraw(loader,player))==NULL)
    return error(SOUND_ERROR_MEMORYNOTENOUGH);
  return server->initialize();
}

bool Wavefileplayer::playing(int verbose)
{
  if(!server->run())return false; // Read first time

  if(verbose>0)
    fprintf(stderr,"Verbose : \n");

  while(server->run());           // Playing


  errorcode=server->geterrorcode();
  if(errorcode==SOUND_ERROR_FINISH)return true;
  return false;
}




// Mpegfileplayer
bool Mpegfileplayer::openfile(char *filename,char *device)
{
// Player
  if(device==NULL)device=defaultdevice;

  if(device[0]=='/')player=new Rawplayer;
  else 
  {
    if(device[0]=='-')device=NULL;
    player=new Rawtofile;
  }

  if(player==NULL)
    return error(SOUND_ERROR_MEMORYNOTENOUGH);
  if(!player->initialize(device))return error(player->geterrorcode());

// Loader
  if((loader=new Soundinputbitstreamfromfile)==NULL)
    return error(SOUND_ERROR_MEMORYNOTENOUGH);
  if(!loader->open(filename))return error(loader->geterrorcode());

// Server
  if((server=new Mpegtoraw(loader,player))==NULL)
    return error(SOUND_ERROR_MEMORYNOTENOUGH);

// Initialize server
  server->initialize();
  return true;
}


void Mpegfileplayer::showverbose(void)
{
  fprintf(stderr,"Verbose: Layer %d, %s,\n\t%dkHz, %dkbit/s, ",
	  server->getlayer(),server->modestring[server->getmode()],
	  server->getfrequency(),server->getbitrate());
  fprintf(stderr,server->getcrccheck() ? "with crc check\n" : 
	                                 "without crc check\n");
}

bool Mpegfileplayer::playing(int useless)
{
  if(!server->run(-1))return false;       // Initialize MPEG Layer 3

  // Set up the data stuff in the dialog box
  char temp[10];
  d->m_bitrate.SetWindowText(_itoa(server->bitrate[server->layer-1][server->bitrateindex],temp,10));
  if(server->mode==server->single)
	d->m_stereo.SetWindowText("mono");
  if(server->mode==server->joint)
	d->m_stereo.SetWindowText("stereo");
  d->m_frequency.SetWindowText(_itoa(server->frequencies[server->frequency],temp,10));

  stereo = server->mode;
  hertz = server->frequencies[server->frequency];
  bitrate = server->bitrate[server->layer-1][server->bitrateindex];
  while(server->run(1));                // Playing

  errorcode=server->geterrorcode();
  if(errorcode==SOUND_ERROR_FINISH)return true;
  return false;
}

