#include <machine/xen-public/xen.h>
#include <machine/xen-public/physdev.h>

/*
 * XXXEN - need to consider whether or not we need to create an offset to real apic
 * id mapping
 */


static inline u_int 
xen_ioapic_read(struct ioapic *io, int reg)
{
	physdev_op_t op;
	int ret;

	op.cmd = PHYSDEVOP_APIC_READ;
	op.u.apic_op.apic_physbase = (unsigned long)io->io_addr;
	op.u.apic_op.reg = reg;
	ret = HYPERVISOR_physdev_op(&op);
	if (ret)
		return ret;
	return op.u.apic_op.value;
}

static inline void 
xen_ioapic_write(struct ioapic *io, int reg, u_int value)
{
	physdev_op_t op;

	op.cmd = PHYSDEVOP_APIC_WRITE;
	op.u.apic_op.apic_physbase = (unsigned long)io->io_addr;
	op.u.apic_op.reg = reg;
	op.u.apic_op.value = value;
	HYPERVISOR_physdev_op(&op);
}


