/*-
 * Copyright (c) 2007 Seccuris Inc.
 * All rights reserved.
 *
 * This sofware was developed by Robert N. M. Watson under contract to
 * Seccuris Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD$
 */

#include <sys/types.h>
#include <sys/ioctl.h>

#include <net/if_tap.h>

#include <errno.h>
#include <fcntl.h>
#include <unistd.h>

#include "zbuf_tap.h"

int
tap_open(void)
{
	int fd;

	fd = open("/dev/tap", O_RDWR);
	if (fd < 0)
		return (-1);
	return(fd);
}

int
tap_getunit(int fd)
{
	u_int unit;

	if (ioctl(fd, TAPGETUNIT, &unit) < 0)
		return (-1);
	return (unit);
}

void
tap_close(int fd)
{

	close(fd);
}

int
tap_send(int fd, u_char *packet, u_int packetlen)
{
	ssize_t len;

	len = write(fd, packet, packetlen);
	if (len < 0)
		return (0);
	if (len != (ssize_t)packetlen) {
		errno = EMSGSIZE;
		return (-1);
	}
	return (0);
}
