/*-
 * Copyright (c) 2007 Seccuris Inc.
 * All rights reserved.
 *
 * This sofware was developed by Robert N. M. Watson under contract to
 * Seccuris Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD$
 */

#ifndef _ZBUF_TAP_H_
#define	_ZBUF_TAP_H_

int	bpf_ackzbuf(int fd, void *buf, u_int buflen);
int	bpf_captureall(int fd);
void	bpf_close(int fd);
int	bpf_getzmax(int fd, u_int *max);
int	bpf_getznext(int fd, void **buf, u_int *buflen);
int	bpf_open(void);
int	bpf_send(int fd, u_char *packet, u_int packetlen);
int	bpf_setbufmode(int fd, u_int bufmode);
int	bpf_setif(int fd, const char *ifname);
int	bpf_setimmediate(int fd, u_int immediate);
int	bpf_setzbuf(int fd, void *bufa, void *bufb, u_int buflen);

void	tap_close(int fd);
int	tap_getunit(int fd);
int	tap_open(void);
int	tap_send(int fd, u_char *packet, u_int packetlen);

#endif /* !_ZBUF_TAP_H_ */
