
#define	MAC_DEFAULT_CONF	"/etc/mac.conf"

#define MAC_MAX_POLICY_NAME	32

struct mac_member {
	char	 mm_name[MAC_MAX_POLICY_NAME];
	void	*mm_data;
	size_t	 mm_databuflen;
	size_t	 mm_datalen;
};

struct mac {
	int			 m_nummembers;
	int			 m_numlivemembers;
	struct mac_member	*m_members;
};

#define	MAC_SUCCESS			0
#define	MAC_ERROR_NOTINIT		1
#define	MAC_ERROR_ALREADYINIT		2
#define	MAC_ERROR_NOSUCHPOLICY		3
#define	MAC_ERROR_NOFROMTEXT		4
#define	MAC_ERROR_INVALIDLABELVALUE	5
#define	MAC_ERROR_POLICYNAMEINVALID	6
#define	MAC_ERROR_INSUFFUCIENTRESOURCES	7
#define	MAC_ERROR_NOTTHISMODULE		8
#define	MAC_ERROR_NOTSUPPORTED		9
#define	MAC_ERROR_UNPARSEABLELABEL	10

const char	*mac_error(int error);
int	mac_destroy(void);
int	mac_init(void);
int	mac_init_conf(const char *conffile);
int	mac_free(struct mac *mac);
int	mac_from_text_np(struct mac **mac, const char *text);
int	mac_prepare(struct mac **mac, int numpolicies,
	    const char *policies[]);
int	mac_to_text_np(struct mac *mac, char **text);

