#include <sys/types.h>

#include <stdio.h>
#include <stdlib.h>

#include "mac.h"

#define	DEFAULT_STRING	"biba/low,mls/high"

int
main(int argc, char *argv[])
{
	const char *string;
	char *outstring;
	struct mac *mac;
	int error;

	error = mac_init();
	if (error != MAC_SUCCESS) {
		fprintf(stderr, "mac_init: %s\n", mac_error(error));
		return (-1);
	}

	if (argc == 1)
		string = DEFAULT_STRING;
	else if (argc == 2)
		string = argv[1];
	else {
		fprintf(stderr, "test [string]\n");
		goto done;
	}

	error = mac_from_text_np(&mac, string);
	if (error != MAC_SUCCESS) {
		fprintf(stderr, "mac_from_text: %s\n", mac_error(error));
		goto done;
	}

	error = mac_to_text_np(mac, &outstring);
	if (error != MAC_SUCCESS) {
		fprintf(stderr, "mac_to_text: %s\n", mac_error(error));
		goto free_mac;
	}

	printf("String: %s\n", outstring);

	free(outstring);
free_mac:
	mac_free(mac);
done:
	mac_destroy();

	return (error);
}
