#!/usr/bin/perl

$outfile = shift(@ARGV);
$datfile = shift(@ARGV);

$graphfile = basename($outfile).".eps";
$releases = 1;

open(OUTFILE, ">".$outfile) || die $outfile;

@names = @ARGV;

print OUTFILE<<End_of_Text;
set terminal postscript eps color solid
#set terminal png
set output "$graphfile"
set ylabel "Commits"
set xlabel "Time"
set xdata time
set timefmt "%Y/%m"
set format x "%m/%y"
set xrange ["1994/04":"2005/04"]

set key left

End_of_Text

if (defined($releases)) {
	open(TICS, "<release-xtics") || die "release-xtics";
	while (<TICS>) {
		print OUTFILE $_;
	}
	close(TICS);
}

#
# Generate a tics key based on likely dates -- if new dates are found in
# the dat file, we might be out of luck come render-time.
#
#$first = 1;
#$nmonths = 12;
#print OUTFILE "set xtics (";
#for ($i = (1994 * 12); $i <= (2005 * 12); $i++) {
#	if ($i % $nmonths == 0) {
#		if ($first == 1) {
#			$first = 0;
#		} else {
#			print OUTFILE ", ";
#		}
#		print OUTFILE '"'.($i % 12 + 1).'/'.($i / 12).'" '.$i;
#	}
#}
#print OUTFILE ")\n";

for ($i = 0; $i <= $#names; $i++) {
	if ($i == 0) {
		print OUTFILE "plot ";
	}
	print OUTFILE '"'.${datfile}.'" using 1:'.($i + 2).' title "'.
	    $names[$i].'" with lines lw 3';
	if ($i != $#names) {
		print OUTFILE ", \\";
	}
	print OUTFILE "\n";
}
close(OUTFILE);

sub basename {
	my($name) = shift(@_);

	$name=~/(.*)(\..+)/;

	return ($1);
}
