#include <sys/types.h>
#include <sys/mac.h>

#include <errno.h>
#include <stdio.h>
#include <string.h>

#define	MAC_MODULE_MYNAME	"mac_foo"

int
mac_module_init(char *policyname, char *conffile, int linenum)
{

	printf("mac_foo says init!\n");

	/* XXX: Optional test for policy in kernel here. */

	if (strcmp(policyname, MAC_MODULE_MYNAME) != 0) {
		fprintf(stderr, "%s:%d: mac_foo doesn't support policy "
		    "\"%s\"\n", conffile, linenum, policyname);
		return (EINVAL);
	}

	return (0);
}

void
mac_module_destroy(char *policyname)
{

	printf("mac_foo says destroy!\n");
}

int
mac_module_from_text(char *policyname, char *text_p, struct mac *label)
{

	printf("mac_foo says from_text(\"%s\")\n", text_p);

	return (0);
}

int
mac_module_to_text(char *policyname, struct mac *label, char **text)
{

	*text = strdup("mac_foo:value");

	return (0);
}

int
mac_module_get_label_for_object(char *policyname, char *objectname,
    struct mac *label)
{

	printf("mac_foo says get_label_for_object(\"%s\")\n", objectname);
	return (0);
}
