#include <sys/types.h>
#include <sys/mac.h>

#include <stdio.h>

#include "mac_module.h"

int
main(int argc, char *argv[])
{
	char *string;
	mac_t label;
	int error;

	error = mac_application_start();
	if (error != 0)
		return (-1);

	label = mac_from_text("test");
	if (label == NULL) {
		perror("mac_from_text");
	}

	mac_free(label);

	label = mac_get_label_for_object("bar");
	if (label == NULL)
		perror("mac_get_label_for_object");

	string = mac_to_text(label, NULL);
	if (string == NULL)
		perror("mac_to_text");
	else
		printf("string: %s\n", string);

	error = mac_application_stop();
	if (error != 0)
		return (-1);

	return (0);
}
